/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSDefinedElement;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSMember;
import filenet.ws.api.WSTemplateBase;
import filenet.ws.api.WSType;
import org.apache.axis.wsdl.symbolTable.BaseType;
import org.apache.axis.wsdl.symbolTable.DefinedElement;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSParameter
extends WSTemplateBase {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSParameter";
    private WSDefinition m_definition = null;
    private WSBindingOperation m_bindingOperation = null;
    private Parameter m_parameter = null;
    private WSDefinedElement m_element = null;
    private WSType m_type = null;
    private String m_paramName = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.17  $";
    }

    public void releaseReferences() {
        block5: {
            try {
                this.m_definition = null;
                if (this.m_bindingOperation != null) {
                    WSBindingOperation bindingOperation = this.m_bindingOperation;
                    this.m_bindingOperation = null;
                    bindingOperation.releaseReferences();
                    bindingOperation = null;
                }
                this.m_parameter = null;
                if (this.m_element != null) {
                    WSDefinedElement element = this.m_element;
                    this.m_element = null;
                    element.releaseReferences();
                    element = null;
                }
                if (this.m_type != null) {
                    WSType type = this.m_type;
                    this.m_type = null;
                    type.releaseReferences();
                    type = null;
                }
                this.m_paramName = null;
                super.releaseReferences();
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block5;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSParameter(WSDefinition definition, WSBindingOperation bindingOperation, Parameter parameter) {
        this.m_definition = definition;
        this.m_bindingOperation = bindingOperation;
        this.m_parameter = parameter;
        if (this.m_parameter != null && this.m_definition != null) {
            this.m_paramName = this.m_parameter.getQName().toString();
            TypeEntry typeEntry = this.m_parameter.getType();
            if (typeEntry != null) {
                if (typeEntry instanceof DefinedElement) {
                    this.m_element = this.m_definition.getDefinedElement((DefinedElement)typeEntry);
                } else if (typeEntry instanceof DefinedType || typeEntry instanceof BaseType) {
                    this.m_type = this.m_definition.getType(typeEntry);
                }
            }
        }
    }

    public String getName() {
        if (this.m_parameter != null) {
            return this.m_parameter.getName();
        }
        return null;
    }

    public WSType getType() {
        return this.m_type;
    }

    public String getDisplayName() {
        if (this.m_parameter != null) {
            return this.m_parameter.getName();
        }
        return null;
    }

    public String getTypeName() {
        return Utils.getXSIType((Parameter)this.m_parameter).getLocalPart();
    }

    public Parameter getParameter() {
        return this.m_parameter;
    }

    String getNamespace() {
        if (this.m_parameter != null && this.m_parameter.getQName() != null) {
            return this.m_parameter.getQName().getNamespaceURI();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    protected void initMembers() {
        if (this.m_members == null && this.m_definition != null) {
            WSMember member = null;
            if (this.m_element != null) {
                member = this.m_definition.getMember(this.m_element);
                if (member == null) {
                    member = this.m_definition.newMember(this.getNamespace(), (Object)this.m_element);
                }
            } else if (this.m_type != null && (member = this.m_definition.getMember(this)) == null) {
                member = this.m_definition.newMember(this.getNamespace(), (Object)this);
            }
            if (member != null && (member.isBaseType() || member.isCollectionElement() || member.isEnum() || member.isChoice() || member.getMemberCount() > 0)) {
                this.m_members = new WSMember[1];
                this.m_members[0] = member;
            }
        }
    }

    void addToTemplate(Document doc, Element e) {
        this.initMembers();
        if (doc != null && e != null && this.m_members != null && this.m_members[0] != null) {
            this.m_members[0].addToTemplate(doc, e);
        }
    }

    protected String getTemplateNamespace() {
        return this.m_definition.getDefinition().getTargetNamespace();
    }

    protected String getTemplateRootName() {
        if (this.m_bindingOperation != null) {
            return this.m_bindingOperation.getDisplayName();
        }
        return null;
    }

    WSDefinition getDefinition() {
        return this.m_definition;
    }

    boolean isPRC() {
        if (this.m_bindingOperation != null) {
            return this.m_bindingOperation.isSoapRPC();
        }
        return false;
    }
}

